% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_operations.R
\name{mix}
\alias{mix}
\alias{mix_}
\alias{pool}
\alias{pool_}
\title{Mix Two or More Survival Distributions}
\usage{
mix(..., weights = 1)

mix_(dots, weights = 1)

pool(...)

pool_(...)
}
\arguments{
\item{...}{Survival distributions to be used in the
projection.}

\item{weights}{A vector of weights used in pooling.}

\item{dots}{Used to work around non-standard evaluation.}
}
\value{
A \code{surv_pooled} object.
}
\description{
Mix a set of survival distributions using the specified
weights.
}
\examples{

dist1 <- define_survival(distribution = "exp", rate = .5)
dist2 <- define_survival(distribution = "gompertz", rate = .5, shape = 1)
pooled_dist <- mix(dist1, dist2, weights = c(0.25, 0.75))

}
