% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_code.R
\name{get_code}
\alias{get_code}
\alias{get_code.uneval_parameters}
\alias{get_code.uneval_matrix}
\alias{get_code.state}
\alias{get_code.uneval_state_list}
\alias{get_code.uneval_model}
\alias{get_code.run_model}
\title{Display the Code to Generate an Object}
\usage{
get_code(x, ...)

\method{get_code}{uneval_parameters}(x, name = NULL, depth = 0,
  n_space = 2, ...)

\method{get_code}{uneval_matrix}(x, name = NULL, depth = 0, n_space = 2,
  ...)

\method{get_code}{state}(x, name = NULL, depth = 0, n_space = 2, ...)

\method{get_code}{uneval_state_list}(x, depth = 0, n_space = 2, ...)

\method{get_code}{uneval_model}(x, name = NULL, sub = FALSE, depth = 0,
  n_space = 2, ...)

\method{get_code}{run_model}(x, name = NULL, sub = FALSE, depth = 0,
  n_space = 2, ...)
}
\arguments{
\item{x}{An \code{heemod} object.}

\item{...}{Additional parameters passed to methods.}

\item{name}{character. Optional argument giving the name
to assign to the object.}

\item{depth}{Depth of the function call.}

\item{n_space}{Number of space used for indentation.}

\item{sub}{logical. Should states or models be referenced
by name in \code{define_strategy} and \code{run_model}
instead of including the entire code?}
}
\value{
A character string.
}
\description{
This function returns the \code{R} code to generate an
\code{heemod} object.
}
\examples{

p <- define_parameters(
  a = 2,
  b = 3 * x + 1
)

get_code(p)

m <- define_transition(
  C, .1,
  0, 1 
)

get_code(m)
}
