% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabular_input.R
\name{construct_part_surv_tib}
\alias{construct_part_surv_tib}
\title{construct a survival object from tabular specification}
\usage{
construct_part_surv_tib(surv_def, fit_tibble, state_names, env = new.env())
}
\arguments{
\item{surv_def}{a data frame with the specification.  See details.}

\item{fit_tibble}{the name of the tibble from which to take fits.}

\item{state_names}{names of the model states}

\item{env}{an environment}
}
\value{
a list with one element for each strategy.   Each element
is in turn a \code{part_surv} object, a list with two elements,
pfs and os.   And those
elements are survival objects of various kinds, with the
commonality that they can be used in \code{\link[=compute_surv]{compute_surv()}}.
}
\description{
construct a survival object from tabular specification
}
\details{
This function is meant to be used only from within
tabular_input.R.   It won't work well otherwise, in that
the environment is unlikely to have what you need.

columns of surv_def:  .strategy, .type, .subset, dist, until
where dist can be either the name of a distribution
along with parameters, or a reference to a fit
for example:  fit('exp') or exp(rate = 0.5)
}
