% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_aedd.R
\name{dfr_aedd}
\alias{dfr_aedd}
\title{Autoencoder-Based Drift Detection method}
\usage{
dfr_aedd(
  encoding_size,
  ae_class = autoenc_encode_decode,
  batch_size = 32,
  num_epochs = 1000,
  learning_rate = 0.001,
  window_size = 100,
  monitoring_step = 1700,
  criteria = "mann_whitney",
  alpha = 0.01,
  reporting = FALSE
)
}
\arguments{
\item{encoding_size}{Encoding Size}

\item{ae_class}{Autoencoder Class}

\item{batch_size}{Batch Size for batch learning}

\item{num_epochs}{Number of Epochs for training}

\item{learning_rate}{Learning Rate}

\item{window_size}{Size of the most recent data to be used}

\item{monitoring_step}{The number of rows that the drifter waits to be is updated}

\item{criteria}{The method to be used to check if there is a drift. May be mann_whitney (default), kolmogorov_smirnov, levene}

\item{alpha}{The significance threshold for the statistical test used in criteria}

\item{reporting}{If TRUE, some data are returned as norm_x_oh, drift_input, hist_proj, and recent_proj.}
}
\value{
\code{dfr_aedd} object
}
\description{
Autoencoder-Based method for concept drift detection \url{doi:0.1109/ICDMW58026.2022.00109}.
}
\examples{
#See an example of using `dfr_aedd` at this
#https://github.com/cefet-rj-dal/heimdall/blob/main/multivariate/dfr_aedd.md
}
