% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_inertia_ahc.R
\name{compute_inertia_ahc}
\alias{compute_inertia_ahc}
\title{Intragroup inertia for choosing the optimal number of clusters in Agglomerative Clustering}
\usage{
compute_inertia_ahc(data, method = "ward.D", max_clusters = 10)
}
\arguments{
\item{data}{R data frame (all columns are required to be numeric types)}

\item{method}{character that specifies the method on which the agglomerative is built upon (by default set to "ward.D")}

\item{max_clusters}{integer that represents the maximal number of clusters for which we intend to compute intra group inertia}
}
\value{
a vector of length \code{max_clusters} containing the inter group inertia for agglomerative
clustering. The ith value of the vector corresponds to the inter group inertia from agglomerative
clustering run with i clusters.
}
\description{
This function allows to compute the inter group inertia from agglomerative clustering
for different number of clusters
}
\examples{
data = iris[c(1:4)]
result <- compute_inertia_ahc(data=data, max_clusters=15)
}
\references{
Link to the author's github package repository:
\url{https://www.github.com/Redcart/helda}
}
\keyword{agglomerative}
\keyword{clustering}
\keyword{data}
\keyword{frame}
\keyword{inertia}
