% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanData.R
\name{cleanData}
\alias{cleanData}
\title{Clean helminth parasite occurrence data}
\usage{
cleanData(edge, speciesOnly = FALSE, validateHosts = FALSE)
}
\arguments{
\item{edge}{Host-parasite edgelist obtained from \code{\link{findLocation}},
\code{\link{findHost}}, or \code{\link{findParasite}}}

\item{speciesOnly}{boolean flag to remove host and parasite species
where data are only available at genus level (default = FALSE)}

\item{validateHosts}{boolean flag to check host species names
against Catalogue of Life information and output taxonomic
information (default = FALSE)}
}
\value{
cleanEdge Host-parasite edgelist, but cleaned
}
\description{
Given a host-parasite edgelist, this function can validate species names,
provide further taxonomic information (thanks to \code{taxize}), 
and remove records only to genus level.
}
\details{
Use \code{data(locations)} for a list of possible locations.
}
\author{
Tad Dallas
}
