% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hull_plot.R
\name{hullPlot}
\alias{hullPlot}
\title{Plot the convex hull of a set of points}
\usage{
hullPlot(
  pointsDF,
  title = "Hull plot",
  xInt = NULL,
  yInt = NULL,
  borderColor = NULL,
  palette = hpColors(),
  hullWidth = 0,
  xLab = "x",
  yLab = "y",
  legendLabs = paste0("Group ", seq(4)),
  legendPos = "bottom",
  pointShape = 4,
  alpha = 0.2,
  labelDF = NULL,
  labelSize = 2.5,
  labelColor = "black",
  labelRepulsion = 1,
  labelPull = 0,
  maxOverlaps = 10,
  ...
)
}
\arguments{
\item{pointsDF}{A data frame with the x and y coordinates of the points.}

\item{title}{Plot title.}

\item{xInt}{The coordinate where the vertical line intersects the x axis.}

\item{yInt}{The coordinate where the horizontal line intersects the y axis.}

\item{borderColor}{The color of the horizontal and vertical dividing lines,
if provided. If \code{NULL}, no dividing lines will be drawn, though the
hull will still be split along these lines (if \code{xInt}
and/or \code{yInt}are not \code{NULL}).}

\item{palette}{Color palette.}

\item{hullWidth}{Width of the convex hull. If 0 (as default), the convex
hull will not be displayed.}

\item{xLab}{Label of x axis.}

\item{yLab}{Label of y axis.}

\item{legendLabs}{Legend labels.}

\item{legendPos}{Legend position.}

\item{pointShape}{Point shape.}

\item{alpha}{Opaqueness level for the colors of the alluvia.}

\item{labelDF}{Label data frame.}

\item{labelSize}{Label size. Ignored if \code{labelDF} is \code{NULL}.}

\item{labelColor}{Label color. Ignored if \code{labelDF} is \code{NULL}.}

\item{labelRepulsion}{Repulsion strength between labels.}

\item{labelPull}{Attraction strength between a text label
and its data point.}

\item{maxOverlaps}{Maximum overlaps. Ignored if \code{labelDF}
is \code{NULL}.}

\item{...}{Other arguments passed to \code{centerTitle}.}
}
\value{
An object of class \code{gg}.
}
\description{
This function plots the convex hull of a set of points. It can also draw
a vertical or a horizontal line (or both), dividing the hull into areas of
different colors.
}
\examples{
pointsDF <- data.frame(x = c(1, 2, 4, 7, 10,
12, 13, 15, 16),
y = c(1, 1, 2, 3, 3, 2,
1, 2, 1))
hullPlot(pointsDF, 'Hull plot', 7, 1.5)

}
