% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocomplete.R
\name{autocomplete}
\alias{autocomplete}
\title{HERE Geocoder API: Autocomplete}
\usage{
autocomplete(addresses, results = 5, url_only = FALSE)
}
\arguments{
\item{addresses}{character, addresses to autocomplete.}

\item{results}{numeric, maximum number of suggestions (Valid range: 1 and 20).}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
A \code{data.table} object, containing the autocomplete suggestions for the addresses.
}
\description{
Completes addresses using the 'Geocoder Autocomplete' API.
}
\examples{
# Authentication
set_auth(
  app_id = "<YOUR APP ID>",
  app_code = "<YOUR APP CODE>"
)

suggestions <- autocomplete(addresses = poi$city, url_only = TRUE)
}
\references{
\href{https://developer.here.com/documentation/geocoder-autocomplete/dev_guide/topics/resource-suggest.html}{HERE Geocoder API: Autocomplete}
}
