% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precompute.R
\name{precompute}
\alias{precompute}
\title{Precompute objects}
\usage{
precompute(B, P, m)
}
\arguments{
\item{B}{A matrix of basis functions}

\item{P}{A penalty matrix}

\item{m}{Difference order of P-spline}
}
\value{
A list of needed objects
}
\description{
This function is an internal function to compute
objects needed for fast implementation of the sandwich
smoother.  It is meant to be an internal function,
so use this at your own risk.
}
\examples{
object = bspline(nbasis = 10)
# sequence to evaluate
evalarg = seq(0, 1, len = 11)
# penalty matrix
D = diffpen(object)
P = Matrix::crossprod(D)
B = predict(object, evalarg)
stuff = precompute(B, P, m = 2)
}
