% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{psm4_exdata}
\alias{psm4_exdata}
\title{Example data for a 4-state partitioned survival model}
\format{
A list containing the following elements:
\itemize{
\item{Survival}{ A data frame containing patient information and time to 3 separate survival endpoints.}
\item{Costs}{A list of data frames. The first data frame contains medical cost data and the
second data frame contains drug cost data.}
}
}
\usage{
psm4_exdata
}
\description{
A collection of example datasets containing simulated survival, costs, and utility data for a 4-state
partitioned survival model.
}
\section{Survival data}{

The survival data frame contains a list of 3 survival curves, each containing the following columns.
\describe{
\item{female}{An indicator variable equal to 1 if the patient is female and 0 otherwise.}
\item{age}{The age of the patient in years.}
\item{strategy_id}{The id of the treatment strategy used.}
\item{endpoint1_time}{Follow up time with right censored data to survival endpoint 1.}
\item{endpoint1_status}{A status indicator for survival endpoint 1 equal to 0 if alive and 1 if dead.}
\item{endpoint2_time}{Follow up time with right censored data to survival endpoint 2.}
\item{endpoint2_status}{A status indicator for survival endpoint 2 equal to 0 if alive and 1 if dead.}
\item{endpoint3_time}{Follow up time with right censored data to survival endpoint 3.}
\item{endpoint3_status}{A status indicator for survival endpoint 3 equal to 0 if alive and 1 if dead.}
}
}

\section{Cost data}{

The cost list contains two data frames.The first data frame contains data on the
medical costs by patient and health state, and contains the following columns:
\describe{
\item{patient_id}{An integer denoting the id of the patient.}
\item{female}{An indicator variable equal to 1 if the patient is female and 0 otherwise.}
\item{state_name}{A categorical variable denoting the three possible health states.}
\item{costs}{Annualized medical costs.}
}

The second data frame contains data on the drug costs associated with each treatment strategy.
\describe{
\item{strategy_id}{The id of each treatment strategy.}
\item{costs}{Annualized drug costs.}
}
}

\keyword{datasets}
