% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statevals.R
\name{stateprobs}
\alias{stateprobs}
\title{State probability object}
\description{
An object of class \code{stateprobs} returned from methods
\verb{$sim_stateprobs()} in model classes.
}
\section{Components}{

A \code{stateprobs} object inherits from \code{data.table} and contains
the following columns:

\describe{
\item{sample}{A random sample from the PSA.}
\item{strategy_id}{The treatment strategy ID.}
\item{patient_id}{The patient ID.}
\item{state_id}{The health state ID.}
\item{t}{The time at which a state probability is computed.}
\item{prob}{The probability of being in a given health state.}
}

When simulating individual-level models, the \code{patient_id} column is
not included as state probabilities are computed by averaging across patients.
}

