% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-fits.R
\name{multinom_list}
\alias{multinom_list}
\title{List of \code{multinom} objects}
\usage{
multinom_list(...)
}
\arguments{
\item{...}{Objects of class \link[nnet:multinom]{multinom}, which can be named.}
}
\value{
An object of class \code{multinom_list}.
}
\description{
Combine \code{multinom} objects into a list.
}
\examples{
 library("nnet")
 library("data.table")
 trans_data <- data.table(multinom3_exdata$transitions)
 dat_healthy <- trans_data[state_from == "Healthy"]
 fit_healthy <- multinom(state_to ~ strategy_name + female + age_cat + year_cat, 
                          data = dat_healthy)
 dat_sick <- trans_data[state_from == "Sick"]
 dat_sick$state_to <- droplevels(dat_sick$state_to)
 fit_sick <- multinom(state_to ~ strategy_name + female + age_cat + year_cat, 
                      data = dat_sick)
 fits <- multinom_list(healthy = fit_healthy, sick = fit_sick)
 class(fits)
}
