% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statevals.R
\name{StateVals}
\alias{StateVals}
\title{Model for state values}
\description{
Simulate values (i.e., utility or costs) associated with health states in a
state transition or partitioned survival model.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{params}}{Parameters for simulating state values. Currently supports
objects of class \code{\link{tparams_mean}} or \code{\link{params_lm}}.}

\item{\code{input_data}}{An object of class \link{input_mats}. Only used for
\code{\link{params_lm}} objects.}

\item{\code{method}}{The method used to simulate costs and
quality-adjusted life-years (QALYs) as a function of state values.
If \code{wlos}, then costs and QALYs are
simulated by weighting state values by the length of stay in a health
state. If \code{starting}, then state values represent a one-time value
that occurs when a patient enters a health state. When \code{starting} is
used in a cohort model, the state values only accrue at time 0;
in contrast, in an individual-level model, state values
accrue each time a patient enters a new state and are discounted based on
time of entrance into that state.}

\item{\code{time_reset}}{If \code{FALSE} then time intervals are based on time since
the start of the simulation. If \code{TRUE}, then time intervals reset each
time a patient enters a new health state. This is relevant if, for example,
costs vary over time within health states. Only used if \code{method = wlos}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{StateVals$new()}}
\item \href{#method-sim}{\code{StateVals$sim()}}
\item \href{#method-check}{\code{StateVals$check()}}
\item \href{#method-clone}{\code{StateVals$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{StateVals} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StateVals$new(
  params,
  input_data = NULL,
  method = c("wlos", "starting"),
  time_reset = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{params}}{The \code{params} field.}

\item{\code{input_data}}{The \code{input_data} field.}

\item{\code{method}}{The \code{method} field.}

\item{\code{time_reset}}{The \code{time_reset} field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{StateVals} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-sim"></a>}}
\if{latex}{\out{\hypertarget{method-sim}{}}}
\subsection{Method \code{sim()}}{
Simulate state values with either predicted means or random samples by
treatment strategy, patient, health state, and time \code{t}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StateVals$sim(t, type = c("predict", "random"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{A numeric vector of times.}

\item{\code{type}}{\code{"predict"} for mean values or \code{"random"} for random samples.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} of simulated state values with columns for \code{sample},
\code{strategy_id}, \code{patient_id}, \code{state_id}, \code{time}, and \code{value}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check"></a>}}
\if{latex}{\out{\hypertarget{method-check}{}}}
\subsection{Method \code{check()}}{
Input validation for class. Checks that fields are the correct type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StateVals$check()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StateVals$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
