% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{incr_effect}
\alias{incr_effect}
\title{Incremental treatment effect}
\usage{
incr_effect(x, comparator, sample, strategy, grp = NULL, outcomes)
}
\arguments{
\item{x}{A \code{data.frame} or \code{data.table} containing simulation output with
information on outcome variables for each randomly sampled parameter set from
a PSA. Each row should denote a randomly sampled parameter set
and treatment strategy.}

\item{comparator}{The comparator strategy. If the strategy column is a character
variable, then must be a character; if the strategy column is an integer variable,
then must be an integer.}

\item{sample}{Character name of column denoting a randomly sampled parameter set.}

\item{strategy}{Character name of column denoting treatment strategy.}

\item{grp}{Character name of column denoting subgroup. If \code{NULL}, then
it is assumed that there is only one group.}

\item{outcomes}{Name of columns to compute incremental changes for.}
}
\value{
A \code{data.table} containing the differences in the values of each variable
specified in outcomes between each treatment strategy and the
comparator.
}
\description{
Computes incremental effect for all treatment strategies
on outcome variables from a probabilistic sensitivity analysis relative to a comparator.
}
\examples{
# simulation output
n_samples <- 100
sim <- data.frame(sample = rep(seq(n_samples), 4),
             c = c(rlnorm(n_samples, 5, .1), rlnorm(n_samples, 5, .1),
                    rlnorm(n_samples, 11, .1), rlnorm(n_samples, 11, .1)),
             e = c(rnorm(n_samples, 8, .2), rnorm(n_samples, 8.5, .1),
                   rnorm(n_samples, 11, .6), rnorm(n_samples, 11.5, .6)),
             strategy = rep(paste0("Strategy ", seq(1, 2)),
                           each = n_samples * 2),
             grp = rep(rep(c("Group 1", "Group 2"),
                           each = n_samples), 2)
)
# calculate incremental effect of Strategy 2 relative to Strategy 1 by group
ie <- incr_effect(sim, comparator = "Strategy 1", sample = "sample",
                        strategy = "strategy", grp = "grp", outcomes = c("c", "e"))
head(ie)
}
