% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TestFunctions.R
\name{sirEval}
\alias{sirEval}
\alias{sirSimulate}
\title{SIR test problem}
\usage{
sirEval(x)

sirSimulate(S0 = 1990, I0 = 10, M = S0 + I0, beta = 0.75, gamma = 0.5,
  imm = 0)
}
\arguments{
\item{x}{vector of size two}

\item{S0}{initial nunber of susceptibles}

\item{I0}{initial number of infected}

\item{M}{total population}

\item{beta, gamma, imm}{control rates}
}
\description{
Epidemiology problem, initial and rescaled to [0,1]^2 versions.
}
\examples{
## SIR test problem illustration
ngrid <- 10 # increase
xgrid <- seq(0, 1, length.out = ngrid)
Xgrid <- as.matrix(expand.grid(xgrid, xgrid))

nrep <- 5 # increase
X <- Xgrid[rep(1:nrow(Xgrid), nrep),]
Y <- apply(X, 1, sirEval)
dataSIR <- find_reps(X, Y)
filled.contour(xgrid, xgrid, matrix(lapply(dataSIR$Zlist, sd), ngrid),
               xlab = "Susceptibles", ylab = "Infecteds", color.palette = terrain.colors)

}
\references{
R. Hu, M. Ludkovski (2017), Sequential Design for Ranking Response Surfaces, SIAM/ASA Journal on Uncertainty Quantification, 5(1), 212-239.
}
