% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precedence_matrix_absolute.R
\name{precedence_matrix_absolute}
\alias{precedence_matrix_absolute}
\title{Precedence Matrix}
\usage{
precedence_matrix_absolute(eventlog, lead = 1)
}
\arguments{
\item{eventlog}{The event log object to be used.}

\item{lead}{The distance between activities following/preceding each other.}
}
\description{
Construct a precedence matrix, showing how activities are followed by each other.
This function computes the precedence matrix directly in C++ for efficiency.
Only the type \code{absolute} of (\code{\link[processmapR]{precedence_matrix}}) is supported.
}
\examples{
library(eventdataR)
data(traffic_fines)
m <- precedence_matrix_absolute(traffic_fines)
print(m)
as.matrix(m)

}
