% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_helpers.R
\name{lonlat_to_cell}
\alias{lonlat_to_cell}
\title{Convert longitude/latitude to cell ID}
\usage{
lonlat_to_cell(lon, lat, grid)
}
\arguments{
\item{lon}{Numeric vector of longitudes in degrees}

\item{lat}{Numeric vector of latitudes in degrees}

\item{grid}{A HexGridInfo or HexData object, or legacy hexify_grid}
}
\value{
Numeric vector of cell IDs
}
\description{
Converts geographic coordinates to DGGS cell IDs using a grid specification.
}
\details{
This function accepts either a HexGridInfo object from \code{hex_grid()} or
a HexData object from \code{hexify()}. If a HexData object is provided,
its grid specification is extracted automatically.
}
\examples{
grid <- hex_grid(area_km2 = 1000)
cells <- lonlat_to_cell(lon = c(0, 10), lat = c(45, 50), grid = grid)

# Or use HexData object
df <- data.frame(lon = c(0, 10, 20), lat = c(45, 50, 55))
result <- hexify(df, lon = "lon", lat = "lat", area_km2 = 1000)
cells <- lonlat_to_cell(lon = 5, lat = 48, grid = result)
}
\seealso{
\code{\link{cell_to_lonlat}} for the inverse operation,
\code{\link{hex_grid}} for creating grid specifications
}
