% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extension-utils.R
\name{crossref_description}
\alias{crossref_description}
\title{Set imports for \emph{DESCRIPTION} file}
\usage{
crossref_description(skip_prompt = FALSE, update = TRUE,
  use_version_numbers = TRUE, rversion = "DEPENDENCIES_VERSION")
}
\arguments{
\item{skip_prompt}{whether to skip the confirmation prompt to change the \emph{DESCRIPTION} file. Defaults to \code{FALSE}.}

\item{update}{whether the \emph{DESCRIPTION} file should be updated. Defaults to \code{TRUE}.}

\item{use_version_numbers}{whether package version numbers should be included in the \emph{DESCRIPTION} file. Defaults to \code{TRUE}.}

\item{rversion}{version of R to be used in the \emph{DESCRIPTION} file.
Can be \code{DEPENDENCIES_VERSION} for the latest version in the package dependencies,
\code{LATEST_VERSION} for the current R version or any valid version number.}
}
\value{
Invisibly returns a list with the current R version,
the R version obtained from dependencies and packages names (including version numbers).
}
\description{
Update the \emph{DESCRIPTION} file with all imported packages stated in the source code.
}
\examples{
\dontrun{crossref_description(skip_prompt=TRUE)}
}
\seealso{
\code{\link[base]{numeric_version}}

Other developer functions: \code{\link{generic_implementations}},
  \code{\link{load_packages}},
  \code{\link{update_settings}},
  \code{\link{valid_pkgname}}
}
\concept{developer functions}
