% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hgwr.R
\name{hgwr}
\alias{hgwr}
\alias{hgwr.sf}
\alias{hgwr.data.frame}
\alias{hgwr_fit}
\title{Hierarchical and Geographically Weighted Regression}
\usage{
hgwr(
  formula,
  data,
  ...,
  bw = "CV",
  kernel = c("gaussian", "bisquared"),
  alpha = 0.01,
  eps_iter = 1e-06,
  eps_gradient = 1e-06,
  max_iters = 1e+06,
  max_retries = 1e+06,
  ml_type = c("D_Only", "D_Beta"),
  verbose = 0
)

\method{hgwr}{sf}(
  formula,
  data,
  ...,
  bw = "CV",
  kernel = c("gaussian", "bisquared"),
  alpha = 0.01,
  eps_iter = 1e-06,
  eps_gradient = 1e-06,
  max_iters = 1e+06,
  max_retries = 1e+06,
  ml_type = c("D_Only", "D_Beta"),
  verbose = 0
)

\method{hgwr}{data.frame}(
  formula,
  data,
  ...,
  coords,
  bw = "CV",
  kernel = c("gaussian", "bisquared"),
  alpha = 0.01,
  eps_iter = 1e-06,
  eps_gradient = 1e-06,
  max_iters = 1e+06,
  max_retries = 1e+06,
  ml_type = c("D_Only", "D_Beta"),
  verbose = 0
)

hgwr_fit(
  formula,
  data,
  coords,
  bw = "CV",
  kernel = c("gaussian", "bisquared"),
  alpha = 0.01,
  eps_iter = 1e-06,
  eps_gradient = 1e-06,
  max_iters = 1e+06,
  max_retries = 1e+06,
  ml_type = c("D_Only", "D_Beta"),
  verbose = 0
)
}
\arguments{
\item{formula}{A formula.
Its structure is similar to \code{\link[lme4]{lmer}} function
in \strong{lme4} package.
Models can be specified with the following form:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{response ~ L(local.fixed) + global.fixed + (random | group)
}\if{html}{\out{</div>}}

For more information, please see the \code{formula} subsection in details.}

\item{data}{The data.}

\item{\dots}{Further arguments for the specified type of \code{data}.}

\item{bw}{A numeric value. It is the value of bandwidth or \code{"CV"}.
In this stage this function only support adaptive bandwidth.
And its unit must be the number of nearest neighbours.
If \code{"CV"} is specified, the algorithm will automatically select an
optimized bandwidth value.}

\item{kernel}{A character value. It specify which kernel function is used
in GWR part. Possible values are
\describe{
\item{\code{gaussian}}{Gaussian kernel function \eqn{k(d)=\exp\left(-\frac{d^2}{b^2}\right)}}
\item{\code{bisquared}}{Bi-squared kernel function. If \eqn{d<b} then \eqn{k(d)=\left(1-\frac{d^2}{b^2}\right)^2} else \eqn{k(d)=0}}
}}

\item{alpha}{A numeric value. It is the size of the first trial step in
maximum likelihood algorithm.}

\item{eps_iter}{A numeric value. Terminate threshold of back-fitting.}

\item{eps_gradient}{A numeric value. Terminate threshold of
maximum likelihood algorithm.}

\item{max_iters}{An integer value. The maximum of iteration.}

\item{max_retries}{An integer value. If the algorithm tends to be diverge,
it stops automatically after trying \emph{max_retires} times.}

\item{ml_type}{An integer value. Represent which maximum likelihood
algorithm is used. Possible values are:
\describe{
\item{\code{D_Only}}{Only \eqn{D} is specified by maximum likelihood.}
\item{\code{D_Beta}}{Both \eqn{D} and \eqn{beta} is specified by maximum likelihood.}
}}

\item{verbose}{An integer value. Determine the log level.
Possible values are:
\describe{
\item{0}{no log is printed.}
\item{1}{only logs in back-fitting are printed.}
\item{2}{all logs are printed.}
}}

\item{coords}{A 2-column matrix.
It consists of coordinates for each group.}
}
\value{
A list describing the model with following fields.
\describe{
\item{\code{gamma}}{Coefficients of local fixed effects.}
\item{\code{beta}}{Coefficients of global fixed effects.}
\item{\code{mu}}{Coefficients of random effects.}
\item{\code{D}}{Variance-covariance matrix of random effects.}
\item{\code{sigma}}{Variance of errors.}
\item{\code{effects}}{A list including names of all effects.}
\item{\code{call}}{Calling of this function.}
\item{\code{frame}}{The DataFrame object sent to this call.}
\item{\code{frame.parsed}}{Variables extracted from the data.}
\item{\code{groups}}{Unique group labels extracted from the data.}
}
}
\description{
A Hierarchical Linear Model (HLM) with local fixed effects.
}
\details{
\subsection{Effect Specification in Formula}{

In the HGWR model, there are three types of effects specified by the
\code{formula} argument:
\describe{
\item{Local fixed effects}{Effects wrapped by functional symbol \code{L}.}
\item{Random effects}{Effects specified outside the functional symbol \code{L} but to the left of symbol \code{|}.}
\item{Global fixed effects}{Other effects}
}
For example, the following formula in the example of this function below is written as

\if{html}{\out{<div class="sourceCode r">}}\preformatted{y ~ L(g1 + g2) + x1 + (z1 | group)
}\if{html}{\out{</div>}}

where \code{g1} and \code{g2} are local fixed effects,
\code{x1} is the global fixed effects,
and \code{z1} is the random effects grouped by the group indicator \code{group}.
Note that random effects can only be specified once!
}
}
\section{Functions}{
\itemize{
\item \code{hgwr_fit()}: Fit a HGWR model

}}
\examples{
data(multisampling)
hgwr(formula = y ~ L(g1 + g2) + x1 + (z1 | group),
     data = multisampling$data,
     coords = multisampling$coords,
     bw = 10)

}
