% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov-miss-mix-wt.R
\name{cov.miss.mix.wt}
\alias{cov.miss.mix.wt}
\title{weighted covariance for data with missing values}
\usage{
cov.miss.mix.wt(
  x,
  means,
  secm,
  wt1 = rep(1/nrow(x), nrow(x)),
  wt2 = rep(1/nrow(x), nrow(x)),
  cor = FALSE,
  center = TRUE,
  method = c("unbiased", "ML")
)
}
\arguments{
\item{x}{the observation matrix, which can contain missing values (NA or NaN)}

\item{means}{a list containing the means of the missing values given observed values}

\item{secm}{a list containing the second moments of the missing values given observed values}

\item{wt1}{the state probabilities matrix (number of observations
times number of states)}

\item{wt2}{the mixture components probabilities list (of length
nstate) of matrices (number of observations times number of
mixture components)}

\item{cor}{logical. if TRUE the weighted correlation is also given}

\item{center}{logical. if TRUE the weighted mean is also given}

\item{method}{with two possible entries:
\itemize{
\item \code{"unbiased"} the unbiased estimator is given
\item \code{"ML"} the maximum likelihood estimator is given
}}
}
\value{
list containing the following items:
\itemize{
\item \code{center} the weighted mean of \code{x}
\item \code{cov} the weighted covariance of \code{x}
\item \code{n.obs} the number of observations in \code{x}
\item \code{cor} the weighted correlation of \code{x},
if the parameter \code{cor} is TRUE
\item \code{wt1} the state weighs \code{wt1}
\item \code{wt2} the mixture component weights \code{wt2}
\item \code{pmix} the estimated mixture proportions
}
}
\description{
The weighted means and variances using the
observation matrix and the estimated weight
vectors for a data matrix containing missing values (NA or NaN)
}
\examples{
data(CMAPSS)
x0 = CMAPSS$train$x[1:CMAPSS$train$N[1], ]
n = nrow(x0)
wt1 = runif(n)
wt2 = runif(n)
p = ncol(x0)
sammissall = sample(1:n, trunc(n / 20))
means = secm = list()
for(ii in 1:n){ 
	if(ii \%in\% sammissall){
   means[[ii]] = colMeans(x0[sammissall, ])
   secm[[ii]] = t(x0[sammissall, ]) \%*\% x0[sammissall, ]
 }else{
  means[[ii]] = secm[[ii]] = NA
 }
}
x0[sammissall,] = NA

cov.miss.mix.wt(x0, means, secm, wt1, wt2)

}
\author{
Morteza Amini, \email{morteza.amini@ut.ac.ir}
}
