\name{hhspec_image}
\alias{hhspec_image}
\title{Display Hilbert Huang spectrogram}
\description{This function displays the Hilbert spectrogram of EMD and EEMD results.}
\usage{
hhspec_image(hspec, time_span, freq_span, amp_span, cluster_span=NULL, 
amp_units=NULL, amp_unit_conversion=NULL, grid=TRUE, colorbar=TRUE, 
backcol=c(0, 0, 0), pretty=TRUE, cex=1, main="")
}
\arguments{
\item{hspec}{Data structure generated by \code{\link{hh_render}}.}
\item{time_span}{Time span to render spectrogram over.  \code{c(0, -1)} will draw the spectrogram over the entire signal.}
\item{freq_span}{Frequency span to render spectrogram over.  \code{c(0, -1)} plots everything up to the max frequency set when \code{\link{hh_render}} was run.}
\item{amp_span}{This is the amplitude span to plot, everything below is set to \code{backcol}, everything above is set to max color, \code{c(0, -1)} scales to the range in the signal.}
\item{cluster_span}{Plots only parts of the signal that have a certain number of data points per pixel (see notes below).  
This only applies when you're plotting EEMD data.  The pixel range is defined as \code{c(AT LEAST, AT MOST)}.}
\item{amp_units}{What to call the amplitude units.}
\item{amp_unit_conversion}{How to convert amplitude units of the input signal to amplitude units on the image}
\item{grid}{Boolean - whether to display grid lines or not}
\item{colorbar}{Boolean - whether to display amplitude colorbar or not}
\item{backcol}{What background color to use behind the spectrogram, in a 3 element vector: \code{c(red, green, blue)}}
\item{pretty}{Boolean - to choose nice axes values or to use exactly the ranges given}
\item{cex}{Font scaling.}
\item{main}{Title of main plot}
}

\details{
This function plots the image generated by \code{\link{hh_render}} along with the original signal.
The plotter can use data from both EMD and EEMD runs.
When it plots EEMD data, it shows the time/frequency plot of every single trial at once.
The \code{cluster_span} option is useful in this case because it can distinguish ``signal'' (pixels where multiple trials intersect) from ``noise'' (whether from EEMD or from nature) where only one trial contributes data.
}

\note{
It may take some trial and error to get a nice image.
For example, if the data points are too small (and thus the spectrogram looks like a mist of fine points rather than continuous frequency bands), try rerunning \code{\link{hh_render}}, but with lower frequency resolution.
If the spectrogram is extremely noisy, try defining \code{cluster_span} - this usually gets rid of most of the random noise.
For example, a \code{cluster_span} of \code{c(3, 10)} only keeps pixels that have data from at least 3 trials, up to 10.  
Most noise pixels will only have one trial contributing data. 
The upper limit (10) is a formality - it does not make much sense at this point to put an upper limit on trial intersections unless you are interested in the \bold{noise} component isolated from the signal.
}

\author{Daniel Bowman \email{daniel.bowman@unc.edu}}

\seealso{
\code{\link{ftspec_image}}, \code{\link{hh_render}}
}
\examples{
data(port_foster_event)

emd_config=list()
emd_config$max_sift=200
emd_config$max_imf=100
emd_config$tol=0.2
emd_config$stop_rule="type5"
emd_config$boundary="wave"
emd_config$sm="none"
emd_config$spar=NA
emd_config$weight=20
emd_config$S=5

trials=10
nimf=10
noise_amp=6.4e-07
trials_dir="test"

set.seed(628)
#Run EEMD (this may take some time)
\dontrun{eemd(sig, dt, trials, nimf, noise_amp, emd_config, trials_dir)}

#Compile the results
\dontrun{eemd_result=eemd_compile(trials_dir, trials, nimf)}

#Calculate spectrogram
max_freq=25
freq_step=0.01
\dontrun{hspec=hh_render(eemd_result, max_freq, freq_step)}

#Plot spectrogram 
time_span=c(5, 10)
freq_span=c(0, 25)
amp_span=c(1e-6, 2.5e-5)
\dontrun{hhspec_image(hspec, time_span, freq_span, amp_span)}
}

\keyword{nonparametric}
