% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realized_measures.R
\name{rKernelCov}
\alias{rKernelCov}
\title{Realized Covariance: Kernel}
\usage{
rKernelCov(rdata, cor = FALSE, align.by = "seconds",
  align.period = 1, makeReturns = FALSE, kernel.type = "rectangular",
  kernel.param = 1, kernel.dofadj = TRUE)
}
\arguments{
\item{rdata}{a \eqn{(M x N)} matrix/zoo/xts object containing the \eqn{N}
return series over period \eqn{t}, with \eqn{M} observations during \eqn{t}.}

\item{cor}{boolean, in case it is TRUE, the correlation is returned. FALSE by default.}

\item{align.by}{Align the tick data to seconds|minutes|hours}

\item{align.period}{Align the tick data to this many [seconds|minutes|hours]}

\item{makeReturns}{Convert to Returns}

\item{kernel.type}{Kernel name (or number)}

\item{kernel.param}{Kernel parameter (usually lags)}

\item{kernel.dofadj}{Kernel Degree of freedom adjustment}
}
\value{
Kernel estimate of realized covariance.
}
\description{
Realized covariance calculation using a kernel estimator.
}
\details{
The different types of kernels can be found using \code{\link{listAvailableKernels}}.
}
\examples{
# Univariate:
rvKernel <- rKernelCov(rdata = sample_tdata$PRICE, align.by = "minutes",
                       align.period = 5, makeReturns = TRUE)
rvKernel

# Multivariate:
rcKernel <- rKernelCov(rdata = cbind(lltc, sbux, fill = 0), align.by = "minutes",
                       align.period = 5, makeReturns = FALSE)
rcKernel
}
\references{
Ole E. Barndorff-Nielsen, Peter Reinhard Hansen, Asger Lunde, and Neil Shephard (2008). Designing Realized Kernels to Measure the ex post Variation of Equity Prices in the Presence of Noise. \emph{Econometrica}, 76, pp. 1481-1536.

B. Zhou. High-frequency data and volatility in foreign-exchange rates. \emph{Journal of Buiness & Economic Statistics}, 14:45-52, 1996.

P. Hansen and A. Lunde. Realized variance and market microstructure noise. \emph{Journal of Business and Economic Statistics}, 24:127-218, 2006.
}
\author{
Scott Payseur and Onno Kleen
}
\keyword{volatility}
