% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDataFromAlphaVantage.R
\name{getAlphaVantageData}
\alias{getAlphaVantageData}
\title{Get high frequency data from Alpha Vantage}
\usage{
getAlphaVantageData(
  symbols = NULL,
  interval = "5min",
  outputType = "xts",
  apiKey = NULL,
  doSleep = TRUE
)
}
\arguments{
\item{symbols}{character vector with the symbols to import.}

\item{interval}{the sampling interval of the data retrieved. Should be one of one of "1min", "5min", "15min", "30min", or "60min"}

\item{outputType}{string either \code{"xts"} or \code{"DT"} to denote the type of output wanted. \code{"xts"} will yield an xts object, \code{"DT"} will yield a data.table object.}

\item{apiKey}{string with the api key provided by Alpha Vantage.}

\item{doSleep}{logical when the length of symbols > 5 the function will sleep for 12 seconds by default.}
}
\value{
An object of type \code{xts} or \code{data.table} in case the length of symbols is 1. If the length of symbols > 1 the \code{xts} and 
\code{data.table} objects will be put into a list.
}
\description{
Function to retrieve high frequency data from Alpha Vantage - wrapper around quantmod's getSymbols.av function
}
\details{
The \code{doSleep} argument is set to true as default because Alpha Vantage has a limit of five calls per minute. 
The function does not try to extract when the last API call was made which means that if
you made successive calls to get 3 symbols in rapid succession, the function may not retrieve all the data.
}
\examples{
\dontrun{
# Get data for SPY at an interval of 1 minute in the standard xts format.
data <- getAlphaVantageData(symbols = "SPY", apiKey = "yourKey", interval = "1min")

# Get data for 3M and Goldman Sachs  at a 5 minute interval in the data.table format. 
# The data.tables will be put in a list.
data <- getAlphaVantageData(symbols = c("MMM", "GS"), interval = "5min", 
                  outputType = "DT", apiKey = 'yourKey')

# Get data for JPM and Citicorp at a 15 minute interval in the xts format. 
# The xts objects will be put in a list.
data <- getAlphaVantageData(symbols = c("JPM", "C"), interval = "15min", 
                  outputType = "xts", apiKey = "yourKey")
}

}
\seealso{
The getSymbols.av function in the quantmod package
}
\author{
Emil Sjoerup (wrapper only) Paul Teetor (for quantmod's getSymbols.av)
}
\keyword{data}
