% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2017-09-14.R
\name{imputationcycle}
\alias{imputationcycle}
\title{Cycling}
\usage{
imputationcycle(data_before, original_data, NA_locator, fe, interaction_names,
  list_of_types, nitt, thin, burnin, mn)
}
\arguments{
\item{data_before}{The data.frame with the variables to impute.}

\item{original_data}{The original data.frame the user passed to \code{hmi}.}

\item{NA_locator}{A n x p matrix localizing the missing values in the original
dataset. The elements are TRUE if the original data are missing and FALSE if the
are observed.}

\item{fe}{A list with the decomposed elements of the \code{model_formula}.}

\item{interaction_names}{A list with the names of the variables
that have been generated as interaction variables}

\item{list_of_types}{a list specifying the types of the variables.
See \code{hmi} for details.}

\item{nitt}{An integer defining number of MCMC iterations (see \code{MCMCglmm}).}

\item{thin}{An integer defining the thinning interval (see \code{MCMCglmm}).}

\item{burnin}{An integer defining the percentage of draws from the gibbs sampler
that should be discarded as burn in (see \code{MCMCglmm}).}

\item{mn}{An integer defining the minimum number of individuals per cluster.}
}
\value{
A data.frame where the values, that have a missing value in the original
dataset, are imputed.
}
\description{
Function to do one imputation cycle on the given data. The function cycles through
every variable sequentially imputing the values, that are NA in the original data set
in that current variable. The function determines the type of the variable
and calls the suitable imputation function.
}
