% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sealevel.R
\name{get_sealevel}
\alias{get_sealevel}
\title{Download and plot essential climate data}
\usage{
get_sealevel(use_cache = TRUE, write_cache = getOption("hs_write_cache"))
}
\arguments{
\item{use_cache}{(boolean) Return cached data if available, defaults to TRUE. Use FALSE to fetch updated data.}

\item{write_cache}{(boolean) Write data to cache, defaults to FALSE. Use TRUE to write data to cache for later use. Can also be set using options(hs_write_cache=TRUE)}
}
\value{
Invisibly returns a tibble with the global mean sea level time series (in mm) over 1880-2013 using tide gauges and since 1993 for satellite measurements.

\code{get_sealevel} invisibly returns a tibble with mean sea level in mm time series from tide gauges and satellite observations.

The satellite observations have been releveled so that their mean level in 1993 matches that of the tide gauges.

The tide gauge data are no longer updated and cover the period from 1880 to 2013, per Church, J. A. and N.J. White (2011) \url{https://research.csiro.au/slrwavescoast/sea-level/measurements-and-data/sea-level-data/}

Satellite data are updated monthly or more frequently from the NOAA Laboratory for Satellite Altimetry. TOPEX and Jason-1,-2,-3 satellites dataset, with seasonal signals removed. \url{https://www.star.nesdis.noaa.gov/socd/lsa/SeaLevelRise/}
}
\description{
Retrieves global mean sea level (GMSL) data from historic tide gauge and recent satellite altimeter observations (in mm).
Source for tide gauge data is Commonwealth Scientific and Industrial Research Organisation (CSIRO) as described in Church and White (2011).
\url{https://research.csiro.au/slrwavescoast/sea-level/measurements-and-data/sea-level-data/} \cr \cr
Source for satellite data is NOAA Laboratory for Satellite Altimetry:
\url{https://www.star.nesdis.noaa.gov/socd/lsa/SeaLevelRise/}
}
\examples{
\donttest{
# Fetch sea level from cache if available:
gmsl <- get_sealevel()
#
# Force cache refresh:
gmsl <- get_sealevel(use_cache=FALSE)
#
# Review cache contents and last update dates:
hockeystick_cache_details()
#
# Plot output using package's built-in ggplot2 settings
plot_sealevel(gmsl) }

}
\references{
\itemize{
\item CSIRO reconstructed tide gauge GMSL for 1880 to 2009: \url{https://research.csiro.au/slrwavescoast/sea-level/measurements-and-data/sea-level-data/}
\item Church, J. A. and N.J. White (2011), Sea-level rise from the late 19th to the early 21st Century. \emph{Surveys in Geophysics}, doi:10.1007/s10712-011-9119-1. \url{https://link.springer.com/article/10.1007/s10712-011-9119-1}
\item NOAA Laboratory for Satellite Altimetry \url{https://www.star.nesdis.noaa.gov/socd/lsa/SeaLevelRise/}
}
}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
