% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seaice.R
\name{plot_seaice}
\alias{plot_seaice}
\title{Download and plot essential climate data}
\usage{
plot_seaice(dataset = get_seaice(), title = "Arctic Sea Ice", print = TRUE)
}
\arguments{
\item{dataset}{Name of the tibble generated by \code{get_seaice}, defaults to calling \code{get_seaice}}

\item{title}{chart title, defaults to Arctic Sea Ice}

\item{print}{(boolean) Display sea ice ggplot2 chart, defaults to TRUE. Use FALSE to not display chart.}
}
\value{
Invisibly returns a ggplot2 object with Sea Ice Index chart
}
\description{
Plots the Sea Ice Index data retrieved using \code{get_seaice()} with ggplot2. The output ggplot2 object may be further modified.
}
\details{
\code{plot_seaice} invisibly returns a ggplot2 object with a pre-defined Sea Ice Index chart using data from \code{get_seaice}.
By default the chart is also displayed. Users may further modify the output ggplot2 chart.
}
\examples{
\donttest{
# Fetch sea ice data:
seaice <- get_seaice()
#
# Plot output using package's built-in ggplot2 defaults
plot_seaice(seaice)

# Or just call plot_seaice(), which defaults to get_seaice() dataset
plot_seaice()

p <- plot_seaice(seaice, print = FALSE)
p + ggplot2::labs(title='Shrinking Arctic Sea Ice') }

}
\author{
Hernando Cortina, \email{hch@alum.mit.edu}
}
