% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{rhglm}
\alias{rhglm}
\title{Random HGLM Data}
\usage{
rhglm(
  n,
  beta,
  sigma = diag(length(beta) - 1L),
  family = gaussian(),
  truncate_mu = FALSE,
  as_list = FALSE,
  ...
)
}
\arguments{
\item{n}{the number of observations to be created.}

\item{beta}{a numeric vector giving the magnitude of the coefficients
(the first element is assumed to be the intercept).}

\item{sigma}{a positive-definite symmetric matrix giving the covariance
structure of the covariates (passed to \code{MASS::mvrnorm}).}

\item{family}{the family of the inverse link.}

\item{truncate_mu}{a logical giving if mu should be truncated if necessary.}

\item{as_list}{a logical (default is \code{FALSE}), if \code{TRUE} a \code{list} is returned
otherwise a \code{data.frame} is returned.}

\item{...}{addtional optional parameters. The arguments are passed to the
random variables generating function of the response.}
}
\value{
A \code{data.frame} (or \code{list}) containing the generated data.
}
\description{
A simple data generator for testing and example purposes.
}
\examples{
rhglm(10, 1:5)
rhglm(10, 1:5, family = binomial())
}
\seealso{
Other simulation: 
\code{\link{cov_matrix}()}
}
\concept{simulation}
