% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constraints.R
\name{pairwise_sign_coherence}
\alias{pairwise_sign_coherence}
\title{Pairwise Sign Coherence}
\usage{
pairwise_sign_coherence(
  rho = 0.8,
  exclude = "(Intercept)",
  big_m = 100,
  eps = 1e-06,
  use = c("everything", "all.obs", "complete.obs", "na.or.complete",
    "pairwise.complete.obs"),
  method = c("pearson", "kendall", "spearman")
)
}
\arguments{
\item{rho}{a value in the range [0,1] specifying the maximum
allowed collinearity between pairs of covariates.}

\item{exclude}{a character vector giving the names of the covariates to be
excluded from the constraint (default is "(Intercept)").}

\item{big_m}{a double giving the big-M parameter.}

\item{eps}{a double giving the epsilon for the equal sign constraint.
Since most numerical solvers can only handle constraints up to some epsilon,
e.g., the constraint \eqn{A x \geq b} is typically transformed to
\eqn{|A x - b| \geq 0}. By providing an \code{eps}\eqn{ > 0} and changing
the constraint to \eqn{|A x - b| \geq} \code{eps} we can ensure \eqn{|A x - b| > 0}.}

\item{use}{an optional character string giving a method for computing
covariances in the presence of missing values.
The parameter is passed to \code{\link[stats]{cor}},
therefore see \code{\link[stats]{cor}} for more information.}

\item{method}{a character string indicating which correlation coefficient
is to be computed.
The parameter is passed to \code{\link[stats]{cor}},
therefore see \code{\link[stats]{cor}} for more information.}
}
\value{
A holistic generalized model constraint, object inheriting from class \code{"hglmc"}.
}
\description{
Ensures that coefficients of covariates which exhibit strong pairwise correlation
have a coherent sign.
}
\references{
Carrizosa E, Olivares-Nadal AV, Ramirez-Cobo P (2020) <doi:10.2436/20.8080.02.95>.
Integer constraints for enhancing interpretability in linear regression.
SORT-Statistics and Operations Research Transactions.
}
\seealso{
Other Constraint-Constructors: 
\code{\link{group_equal}()},
\code{\link{group_inout}()},
\code{\link{group_sparsity}()},
\code{\link{include}()},
\code{\link{k_max}()},
\code{\link{linear}()},
\code{\link{lower}()},
\code{\link{rho_max}()},
\code{\link{sign_coherence}()},
\code{\link{upper}()}
}
\concept{Constraint-Constructors}
