% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{truncatedNormalMoment}
\alias{truncatedNormalMoment}
\title{Calculate k-th order moment of truncated normal distribution}
\usage{
truncatedNormalMoment(k = 1L, x_lower = numeric(0),
  x_upper = numeric(0), mean = 0, sd = 1, pdf_lower = numeric(0),
  cdf_lower = numeric(0), pdf_upper = numeric(0),
  cdf_upper = numeric(0), cdf_difference = numeric(0),
  return_all_moments = FALSE, is_validation = TRUE)
}
\arguments{
\item{k}{non-negative integer moment order.}

\item{x_lower}{numeric vector of lower trancation points.}

\item{x_upper}{numeric vector of upper trancation points.}

\item{mean}{numeric expected value.}

\item{sd}{positive numeric standard deviation.}

\item{pdf_lower}{non-negative numeric matrix of precalculated normal density functions 
with mean \code{mean} and standard deviation \code{sd} at points given by \code{x_lower}.}

\item{cdf_lower}{non-negative numeric matrix of precalculated normal cumulative distribution functions 
with mean \code{mean} and standard deviation \code{sd} at points given by \code{x_lower}.}

\item{pdf_upper}{non-negative numeric matrix of precalculated normal density functions 
with mean \code{mean} and standard deviation \code{sd} at points given by \code{x_upper}.}

\item{cdf_upper}{non-negative numeric matrix of precalculated normal cumulative distribution functions 
with mean \code{mean} and standard deviation \code{sd} at points given by \code{x_upper}.}

\item{cdf_difference}{non-negative numeric matrix of predcalculated \code{cdf_upper-cdf_lower} values.}

\item{return_all_moments}{logical; if \code{TRUE}, function returns the matrix of
moments of normaly distributed random variable with mean = \code{mean}
and standard deviation = \code{sd} under lower and upper truncation points
\code{x_lower} and \code{x_upper} correspondingly. Note that element in i-th row and
j-th column of this matrix corresponds to the i-th observation (j-1)-th
order moment.}

\item{is_validation}{bool value indicating whether function input arguments should be validated. 
Set it to FALSE for slight perfomance boost (default value is TRUE).}
}
\value{
This function returns vector of k-th order moments for normaly distributed random variable
with mean = \code{mean} and standard deviation = \code{sd} under x_lower
and x_upper truncation points \code{x_lower} and \code{x_upper} correspondingly.
If \code{return_all_moments} is \code{TRUE} then see this argument description above for
output details.
}
\description{
This function iteratively calculates k-th order moment of truncated normal distribution.
}
\details{
This function estimates \code{k}-th order moment of
normal distribution which mean equals to \code{mean} and standard deviation equals to \code{sd} truncated
at points given by \code{x_lower} and \code{x_upper}. Note that the function is vectorized so you can provide
\code{x_lower} and \code{x_upper} as vectors of equal size. If vectors values for \code{x_lower} and \code{x_upper} are not
provided then their default values will be set to (-9999999999999.1) and (9999999999999.1) correspondingly.

Note that parameter \code{k} value automatically converts to integer.
So passing non-integer \code{k} value will not cause any errors but the calculations will be
performed for rounded \code{k} value only.

If you have precaulculated density or cumulative distribution
functions at standartized truncation points (substract \code{mean} and then divide by \code{sd}) 
then provide them throught \code{pdf_lower}, \code{pdf_upper}, \code{cdf_lower} and \code{cdf_upper}
arguments in order to decrease number of calculations.
}
\examples{
##Calculate 5-th order moment of three truncated normal random variables (x1,x2,x3) 
##which mean is 5 and standard deviation is 3. 
##These random variables truncation points are given as follows:-1<x1<1, 0<x2<2, 1<x3<3.
k <- 3
x_lower <- c(-1, 0, 1)
x_upper <- c(1, 2 ,3)
mean <- 3
sd <- 5

#get the moments
truncatedNormalMoment(k, x_lower, x_upper, mean, sd)

#get matrix of (0-5)-th moments (columns) for each variable (rows)
truncatedNormalMoment(k, x_lower, x_upper, mean, sd, return_all_moments = TRUE)

}
