% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelToIndex.R
\name{modelToIndex}
\alias{modelToIndex}
\title{Convert model results into a house price index}
\usage{
modelToIndex(model_obj, max_period = max(model_obj$coefficients$time), ...)
}
\arguments{
\item{model_obj}{Model results object}

\item{max_period}{Maximum number of periods that should have been estimated.}

\item{...}{Additional arguments}
}
\value{
`hpiindex` object containing:
\item{name}{vector of period names}
\item{numeric}{vector of period in numeric form}
\item{period}{vector of period numbers}
\item{value}{`ts` object of the index values}
\item{imputed}{vector of binary values indicating imputation}
}
\description{
Converts model results to standardized index objects
}
\examples{

 # Load data
 data(ex_sales)

 # With a raw transaction data.frame
 rt_data <- rtCreateTrans(trans_df = ex_sales,
                          prop_id = 'pinx',
                          trans_id = 'sale_id',
                          price = 'sale_price',
                          periodicity = 'monthly',
                          date = 'sale_date')

 # Create model object
 hpi_model <- hpiModel(hpi_df = rt_data,
                       estimator = 'base',
                       log_dep = TRUE)

 # Create Index
 hpi_index <- modelToIndex(hpi_model,
                           max_period = 84)

}
