% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcKFoldError.R
\name{createKFoldData}
\alias{createKFoldData}
\title{Create data for KFold error test}
\usage{
createKFoldData(score_ids, full_data, pred_df)
}
\arguments{
\item{score_ids}{Vector of row ids to be included in scoring data}

\item{full_data}{Complete dataset (class `hpidata``) of this model type (rt or hed)}

\item{pred_df}{Data to be used for prediction}
}
\value{
list of length 2 containing:
\describe{
  \item{train}{Training data.frame}
  \item{score}{Scoring data.frame}
}
}
\description{
Generic method for creating KFold testing data
}
\section{Further Details}{

Called from `calcKFoldError()``
}

\examples{

 # Load Data
 data(ex_sales)

 # Create RT Data
 rt_data <- rtCreateTrans(trans_df = ex_sales,
                          prop_id = 'pinx',
                          trans_id = 'sale_id',
                          price = 'sale_price',
                          periodicity = 'monthly',
                          date = 'sale_date')
 # Create folds
 k_folds <- caret::createFolds(y = 1:nrow(rt_data),
                               k = 10,
                               list = TRUE,
                               returnTrain = FALSE)

 # Create data from folds
 kfold_data <- createKFoldData(score_ids = k_folds[[1]],
                               full_data = rt_data,
                               pred_df = rt_data)

}
