% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{LDdam}
\alias{LDdam}
\title{Calculation of maternal LD matrix}
\usage{
LDdam(inMat, pos_chr)
}
\arguments{
\item{inMat}{[MATRIX] The maternal HAPLOTYPE matrix.}

\item{pos_chr}{[LIST] The marker positions in Morgan on chromosomes.}
}
\value{
\describe{
  \item{\code{Dd}}{(p x p) matrix of maternal LD}
}
}
\description{
Matrix containing linkage disequilibrium between marker pairs
  on maternal gametes is set up by counting haplotypes frequencies.
}
\details{
The function generates a block diagonal sparse matrix based on
  Matrix::bdiag. Use as.matrix() to obtain a regular one.
}
\examples{
 ## haplotype matrix of n individuals at p SNPs
 p <- 10; n <- 4
 mat <- matrix(ncol = p, nrow = 2 * n, sample(c(0, 1), size = 2 * n * p, replace = TRUE))
 LDdam(mat, list(1:p))
}
