% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotOutcomes.R
\name{plotOutcomes}
\alias{plotOutcomes}
\title{Intermediate function for \code{hte_plot_line}}
\usage{
plotOutcomes(
  treatment,
  outcome,
  propscores,
  confInt = TRUE,
  colbyWt = FALSE,
  ylab = "",
  xlab = "",
  title = "",
  gamma = 0,
  lambda = 0,
  ...
)
}
\arguments{
\item{treatment}{a character representing the column name
for the treatment variable in the causal setup}

\item{outcome}{a character representing the column name
of the outcome variable.}

\item{propscores}{a character representing the column name of
the propensity score.}

\item{confInt}{a logical value indicating whether adding the 95%
confidence interval. The default is set as \code{TRUE}.}

\item{colbyWt}{a logical value indicating whether the points are
are colored according to inverse propensity scores. The default is
set as FALSE.}

\item{xlab, ylab, title}{Characters representing the name for x axis,
y axis, and main title for each node.}

\item{gamma, lambda}{numbers indicating the bias level used in
sensitivity analysis}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A summary table after adjusting the estimates with
inverse probability weighting (ipw).
}
\description{
Plots the
different least squares models used to estimate heterogeneous
treatment effects(HTE) at each node. At each node, this
visualization aims to show how the estimated treatment effect
differs when using ordinary least squares and weighted least
squares methods. The weighted least squares method in this
package uses
inverse propensity scores as weights, in order to reduce
bias due to confounding variables.
}
