% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_convert_hdsm2hts.R
\name{f_convert_hdsm2hts}
\alias{f_convert_hdsm2hts}
\title{Convert a HDSM output file in hts files for plotting}
\usage{
f_convert_hdsm2hts(filein, station = "sta", var)
}
\arguments{
\item{filein}{HDSM output file}

\item{station}{station name (default="sta")}

\item{var}{variable name}
}
\value{
In calval mode, two hts files : one "obs" and one "simul".

In blind mode, one hts file.
}
\description{
Convert a HDSM output file in hts files for plotting
}
\details{
Three types of HDSM output files are treated ; two in blind mode : hydro_d and snow_d ;
one in calval mode, which includes an observed and simulated variable.

In blind mode, the variable name must be chosen between the following ones:
"Psoil_km3", "Psoil_mm", "ETP_km3", "ETP_mm", "Etr_km3", "Plake_km3", "Evap_km3",
"Infil_km3", "Runoff_m3/s", "Drain_m3/s", "Q_m3/s", "Q_mm", "Slake_km2", "Slandice_km2",
"SoilLiq_mm", "dSoilLiq_km3", "VLake_km3", "dVLake_mm", "Flux_mm", "Pliq_km3", "Psol_km3",
"Melts_km3", "Subli_km3", "Melti_km3", "Q_km3", "Slandicekm2", "Sca_km2", "Sca_%",
"Swe_km3", "Swe_mm", "dSwe_km3", "SoilIce_km3", "SoilIce_mm", "dSoilIce_km3"

The variable name is affected to the sensor of the hts file.

In calval mode, the variable can take any value.

The function calls the sp_plothts function, displaying graphically the hts file(s) and allowing to personalize
the plot.
}
\seealso{
\code{\link{f_convert_hts2hdsm}} \code{\link{ps_plothts}}
}
\author{
P. Chevallier - October 2017 - December 2021
}
