% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_pradeep2020.R
\name{load_pradeep2020}
\alias{load_pradeep2020}
\title{Load data from Pradeep et al. 2020.}
\usage{
load_pradeep2020(overwrite = FALSE, target.env = .GlobalEnv)
}
\arguments{
\item{overwrite}{Only matters if load.image=FALSE. If overwrite=TRUE then
existing data in chem.physical_and_invitro.data will be replaced by any
data/predictions in Pradeep et al. (2020) that is for the same chemical and
property. If overwrite=FALSE (DEFAULT) then new data for the same chemical
and property are ignored.  Funbound.plasma values of 0 (below limit of
detection) are overwritten either way.}

\item{target.env}{The environment where the new
chem.physical_and_invitro.data is loaded. Defaults to global environment.}
}
\value{
\item{data.frame}{An updated version of
chem.physical_and_invitro.data.}
}
\description{
This function returns an updated version of chem.physical_and_invitro.data
that includes data predicted with Support Vector Machine and Random Forest 
models developed and presented in Pradeep et al. 2020, included in
pradeep2020.
}
\examples{

\dontrun{
chem.physical_and_invitro.data <- load_pradeep2020()
chem.physical_and_invitro.data <- load_pradeep2020(overwrite=TRUE) 
}                        

}
\references{
\insertRef{pradeep2020chemstr}{httk}
}
\author{
Sarah E. Davidson
}
