% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_pbtk.R
\name{parameterize_pbtk}
\alias{parameterize_pbtk}
\title{Parameters for a generic physiologically-based toxicokinetic model}
\usage{
parameterize_pbtk(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  default.to.human = FALSE,
  tissuelist = list(liver = c("liver"), kidney = c("kidney"), lung = c("lung"), gut =
    c("gut")),
  force.human.clint.fup = FALSE,
  clint.pvalue.threshold = 0.05,
  adjusted.Funbound.plasma = TRUE,
  adjusted.Clint = TRUE,
  regression = TRUE,
  suppress.messages = FALSE,
  restrictive.clearance = TRUE,
  minimum.Funbound.plasma = 1e-04,
  million.cells.per.gliver = 110,
  liver.density = 1.05,
  kgutabs = 2.18
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing animal values with human values
if true (hepatic intrinsic clearance or fraction of unbound plasma).}

\item{tissuelist}{Specifies compartment names and tissues groupings.
Remaining tissues in tissue.data are lumped in the rest of the body.
However, \code{\link{solve_pbtk}} only works with the default parameters.}

\item{force.human.clint.fup}{Forces use of human values for hepatic
intrinsic clearance and fraction of unbound plasma if true.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}

\item{adjusted.Funbound.plasma}{Uses Pearce et al. (2017) lipid binding adjustment
for Funbound.plasma (which impacts partition coefficients) when set to TRUE (Default).}

\item{adjusted.Clint}{Uses Kilford et al. (2008) hepatocyte incubation
binding adjustment for Clint when set to TRUE (Default).}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{restrictive.clearance}{In calculating hepatic.bioavailability, protein
binding is not taken into account (set to 1) in liver clearance if FALSE.}

\item{minimum.Funbound.plasma}{\eqn{f_{up}} is not allowed to drop below
this value (default is 0.0001).}

\item{million.cells.per.gliver}{Hepatocellularity (defaults to 110 10^6 cells/g-liver, from Carlile et al. (1997))}

\item{liver.density}{Liver density (defaults to 1.05 g/mL from International Commission on Radiological Protection (1975))}

\item{kgutabs}{Oral absorption rate from gut (defaults to 2.18 1/h from Wambaugh et al. (2018))}
}
\value{
\item{BW}{Body Weight, kg.} 
\item{Clmetabolismc}{Hepatic Clearance, L/h/kg BW.} 
\item{Fgutabs}{Fraction of the oral dose absorbed, i.e. the fraction of
the dose that enters the gutlumen.} 
\item{Funbound.plasma}{Fraction of plasma that is not bound.}
\item{Fhep.assay.correction}{The fraction of chemical unbound in hepatocyte
assay using the method of Kilford et al. (2008)}
\item{hematocrit}{Percent volume of red blood cells in the blood.}
\item{Kgut2pu}{Ratio of concentration of chemical in gut tissue to unbound
concentration in plasma.}
\item{kgutabs}{Rate that chemical enters the gut from gutlumen, 1/h.}
\item{Kkidney2pu}{Ratio of concentration of chemical in kidney tissue to
unbound concentration in plasma.}
\item{Kliver2pu}{Ratio of concentration of chemical in liver tissue to
unbound concentration in plasma.} 
\item{Klung2pu}{Ratio of concentration of chemical in lung tissue
to unbound concentration in plasma.} 
\item{Krbc2pu}{Ratio of concentration of chemical in red blood cells to
unbound concentration in plasma.}
\item{Krest2pu}{Ratio of concentration of chemical in rest of body tissue to
unbound concentration in plasma.}
\item{million.cells.per.gliver}{Millions cells per gram of liver tissue.}
\item{MW}{Molecular Weight, g/mol.}
\item{Qcardiacc}{Cardiac Output, L/h/kg BW^3/4.}
\item{Qgfrc}{Glomerular Filtration Rate, L/h/kg BW^3/4, volume of fluid
filtered from kidney and excreted.}
\item{Qgutf}{Fraction of cardiac output flowing to the gut.}
\item{Qkidneyf}{Fraction of cardiac output flowing to the kidneys.}
\item{Qliverf}{Fraction of cardiac output flowing to the liver.}
\item{Rblood2plasma}{The ratio of the concentration of the chemical in the
blood to the concentration in the plasma from available_rblood2plasma.}
\item{Vartc}{Volume of the arteries per kg body weight, L/kg BW.}
\item{Vgutc}{Volume of the gut per kg body weight, L/kg BW.}
\item{Vkidneyc}{Volume of the kidneys per kg body weight, L/kg BW.}
\item{Vliverc}{Volume of the liver per kg body weight, L/kg BW.}
\item{Vlungc}{Volume of the lungs per kg body weight, L/kg BW.}
\item{Vrestc}{ Volume of the rest of the body per kg body weight, L/kg BW.}
\item{Vvenc}{Volume of the veins per kg body weight, L/kg BW.}
}
\description{
Generate a chemical- and species-specific set of PBPK model parameters.
Parameters include 
tissue:plasma partition coefficients, organ volumes, and flows 
for the tissue lumping scheme specified by argument tissuelist.
Tissure:(fraction unbound in) plasma partitition coefficients are predicted
via Schmitt (2008)'s method as modified by Pearce et al. (2017) using
\code{\link{predict_partitioning_schmitt}}. Organ volumes and flows are
retrieved from table \code{\link{physiology.data}}.
Tissues must be described in table \code{\link{tissue.data}}.
}
\details{
By default, this function initializes the parameters needed in the functions 
\code{\link{solve_pbtk}}, \code{\link{calc_css}}, and others using the httk 
default generic PBTK model (for oral and intravenous dosing only).
}
\examples{

 parameters <- parameterize_pbtk(chem.cas='80-05-7')

 parameters <- parameterize_pbtk(chem.name='Bisphenol-A',species='Rat')

 # Change the tissue lumping (note, these model parameters will not work with our current solver):
 compartments <- list(liver=c("liver"),fast=c("heart","brain","muscle","kidney"),
                      lung=c("lung"),gut=c("gut"),slow=c("bone"))
 parameterize_pbtk(chem.name="Bisphenol a",species="Rat",default.to.human=TRUE,
                   tissuelist=compartments) 
}
\references{
Pearce, Robert G., et al. "Httk: R package for high-throughput 
toxicokinetics." Journal of statistical software 79.4 (2017): 1.

Schmitt, Walter. "General approach for the calculation of tissue 
to plasma partition coefficients." Toxicology in vitro 22.2 (2008): 457-467.

Pearce, Robert G., et al. "Evaluation and calibration of high-throughput 
predictions of chemical distribution to tissues." Journal of pharmacokinetics 
and pharmacodynamics 44.6 (2017): 549-565.

Kilford, P. J., Gertz, M., Houston, J. B. and Galetin, A.
(2008). Hepatocellular binding of drugs: correction for unbound fraction in
hepatocyte incubations using microsomal binding or drug lipophilicity data.
Drug Metabolism and Disposition 36(7), 1194-7, 10.1124/dmd.108.020834.

Carlile, David J., Katayoun Zomorodi, and J. Brian Houston. "Scaling factors 
to relate drug metabolic clearance in hepatic microsomes, isolated 
hepatocytes, and the intact liver: studies with induced livers involving 
diazepam." Drug metabolism and disposition 25.8 (1997): 903-911.

International Commission on Radiological Protection. Report of the task 
group on reference man. Vol. 23. Pergamon, Oxford. 1975.

Wambaugh, John F., et al. "Evaluating in vitro-in vivo extrapolation of 
toxicokinetics." Toxicological Sciences 163.1 (2018): 152-169.
}
\seealso{
\code{\link{solve_pbtk}}

\code{\link{calc_analytic_css_pbtk}}

\code{\link{predict_partitioning_schmitt}}

\code{\link{apply_clint_adjustment}}

\code{\link{tissue.data}}

\code{\link{physiology.data}}
}
\author{
John Wambaugh and Robert Pearce
}
\keyword{Parameter}
\keyword{pbtk}
