% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_elimination_rate.R
\name{calc_elimination_rate}
\alias{calc_elimination_rate}
\title{Calculate the elimination rate for a one compartment model}
\usage{
calc_elimination_rate(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  species = "Human",
  suppress.messages = TRUE,
  default.to.human = FALSE,
  restrictive.clearance = TRUE,
  adjusted.Funbound.plasma = TRUE,
  adjusted.Clint = TRUE,
  regression = TRUE,
  well.stirred.correction = TRUE,
  clint.pvalue.threshold = 0.05,
  minimum.Funbound.plasma = 1e-04
)
}
\arguments{
\item{chem.cas}{Either the cas number or the chemical name must be
specified.}

\item{chem.name}{Either the chemical name or the cas number must be
specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_steadystate or
1compartment function, overrides chem.name and chem.cas.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{restrictive.clearance}{In calculating elimination rate, protein
binding is not taken into account (set to 1) in liver clearance if FALSE.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with partition coefficients calculated with this value.}

\item{adjusted.Clint}{Uses Kilford et al. (2008) hepatocyte incubation
binding adjustment for Clint when set to TRUE (Default).}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{well.stirred.correction}{Uses correction in calculation of hepatic
clearance for -stirred model if TRUE.  This assumes clearance relative
to amount unbound in whole blood instead of plasma, but converted to use
with plasma concentration.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}
}
\value{
\item{Elimination rate}{Units of 1/h.}
}
\description{
This function calculates an elimination rate from the three compartment
steady state model where elimination is entirely due to metablism by the
liver and glomerular filtration in the kidneys.
}
\details{
Elimination rate calculated by dividing the total clearance (using the
default -stirred hepatic model) by the volume of distribution. When
species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitues human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.
}
\examples{

calc_elimination_rate(chem.name="Bisphenol A")
\dontrun{
calc_elimination_rate(chem.name="Bisphenol A",species="Rat")
calc_elimination_rate(chem.cas="80-05-7")
}

}
\references{
Schmitt, Walter. "General approach for the calculation of tissue 
to plasma partition coefficients." Toxicology in vitro 22.2 (2008): 457-467.

\insertRef{dawson2021qsar}{httk} 

\insertRef{kilford2008hepatocellular}{httk}
}
\author{
John Wambaugh
}
\keyword{1compartment}
\keyword{Parameter}
