% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_input_param_timeseries.R
\name{get_input_param_timeseries}
\alias{get_input_param_timeseries}
\title{Get timeseries containing the change of each of the input parameters.}
\usage{
get_input_param_timeseries(
  model,
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  initial.params = NULL,
  initial.percentiles = NULL,
  start.age = 360,
  days = 10,
  gender = c("Male", "Female"),
  weight_category = c("Underweight", "Normal", "Overweight", "Obese"),
  gfr_category = c("Normal", "Kidney Disease", "Kidney Failure"),
  reths = c("Mexican American", "Other Hispanic", "Non-Hispanic White",
    "Non-Hispanic Black", "Other"),
  bandwidth = 12,
  get.median.param.vals = FALSE,
  input.param.dir = NULL
)
}
\arguments{
\item{model}{The name of a model which can accept timeseries as forcing functions.}

\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{initial.params}{The values for each parameter at the beginning of the simulation.
All compiled parameters should be present. The output of the parameterize_<model>
function is appropriate for \code{initial.params}.}

\item{initial.percentiles}{If \code{initial.params} are not provided, \code{initial.percentiles}
will designate a starting value for each parameter according to the corresponding 
percentile within the NHANES population. Values should be between zero and one. If 
neither \code{initial.params} nor \code{initial.percentiles} are provided, the initial
value for the parameter is taken to be the median of the population value.}

\item{start.age}{The age in months of the individual at the beginning of the simulation. 
Used for determining the percentile score of the initial parameter values when producing
the timeseries determining parameter changes.}

\item{days}{The length of the simulation in days. Equivalent to the \code{days}
parameter in \code{\link{solve_model}}.

The next four parameters play the same role here as in \code{\link{httkpop_generate}}:
the user may restrict the data available to the non-parametric regression by 
specifying demographics.}

\item{gender}{Optional: The gender categories to include in the popualtion; 
default \code{c("Female", "Male")}.}

\item{weight_category}{Optional: The weight categories to include in the
population. Default is \code{c('Underweight', 'Normal', 'Overweight',
'Obese')}. User-supplied vector must contain one or more of these strings.}

\item{gfr_category}{The kidney function categories to include in the
population. Default is \code{c('Normal','Kidney Disease', 'Kidney
Failure')} to include all kidney function levels.}

\item{reths}{Optional: a character vector giving the races/ethnicities to
include in the population. Default is \code{c('Mexican American','Other
Hispanic','Non-Hispanic White','Non-Hispanic Black','Other')}, to include
all races and ethnicities in their proportions in the NHANES data.
User-supplied vector must contain one or more of these strings.}

\item{bandwidth}{Dictates the length of time centered around the present to use
when calculating non-parametric regressions.}

\item{get.median.param.vals}{Return, instead of the timeseries, the median values
for the dynamic model parameters at the given start age.}

\item{input.param.dir}{The path to the \code{input_params_data_files} directory,
which is used to store all \code{input_param} data files. If \code{input_params_data_files}
does not exist, this function will create it in the specified path. Default \code{NULL}, 
in which case the present working directory is used as default.}
}
\value{
A list of two-column matrices indexed by names of compiled parameters for
the designated model. The first column contains a list of times (in days) and the 
second the total change in that parameter from the initial value.
}
\description{
The \code{deSolve} package uses timeseries as forcing functions. In lieu of hard-
coding time evolution of parameters into a model, these timeseries may be used
to change the value of parameters in time. The function \code{get_input_parm_timeseries}
queries a virutal population and non-parametrically produces timeseries that 
preserve the percentile score of the given starting values.
}
\details{
For each time-dependent model, there should be a function (such as \code{\link{gen_input_params}})
that determines the model parameter values for each individual in the NHANES dataset.
The resulting value are used to form the non-parametric regression curve.
}
\examples{
\donttest{

params <- parameterize_pbtk(chem.name = 'Bisphenol A')
ts <- get_input_param_timeseries("pbtk_lifestage",
                                 chem.name = 'Bisphenol A',
                                 initial.params = params,
                                 start.age = 600, # age fifty
                                 days = 365,
                                 weight_category=c('Underweight',
                                                   'Normal',
                                                   'Overweight'))

}

}
\seealso{
\code{\link{solve_pbtk_lifestage}}

\code{\link{gen_input_params}}
}
\author{
Colin Thomson
}
\keyword{lifestage}
