% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redact.R
\name{gsub_response}
\alias{gsub_response}
\alias{gsub_request}
\title{Find and replace within a 'response' or 'request'}
\usage{
gsub_response(response, pattern, replacement, ...)

gsub_request(request, pattern, replacement, ...)
}
\arguments{
\item{response}{An 'httr' \code{response} object to sanitize.}

\item{pattern}{From \code{\link[base:grep]{base::gsub()}}: "character string containing a regular
expression (or character string for \code{fixed = TRUE}) to be matched in the
given character vector." Passed to \code{gsub()}. See the docs for \code{gsub()} for
further details.}

\item{replacement}{A replacement for the matched pattern, possibly including
regular expression backreferences. Passed to \code{gsub()}. See the docs for
\code{gsub()} for further details.}

\item{...}{Additional logical arguments passed to \code{gsub()}: \code{ignore.case},
\code{perl}, \code{fixed}, and \code{useBytes} are the possible options.}

\item{request}{An 'httr' \code{request} object to sanitize.}
}
\value{
A \code{request} or \code{response} object, same as was passed in, with the
pattern replaced in the URLs and bodies.
}
\description{
These functions pass their arguments to \code{\link[base:grep]{base::gsub()}} in order to find and
replace string patterns (regular expressions) within \code{request} or \code{response}
objects. \code{gsub_request()} replaces in the request URL and any request body
fields; \code{gsub_response()} replaces in the response URL, the response body,
and it calls \code{gsub_request()} on the \code{request} object found within the
\code{response}.
}
\details{
Note that, unlike \code{gsub()}, the first argument of the function is \code{request}
or \code{response},
not \code{pattern}, while the equivalent argument in \code{gsub()}, "\code{x}", is placed
third. This difference is to maintain consistency with the other redactor
functions in \code{httptest}, which all take \code{response} as the first argument.
}
