% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\docType{methods}
\name{QCcode}
\alias{QCcode}
\alias{QCcode,ChipInfo-method}
\alias{QCcode<-}
\alias{QCcode<-,ChipInfo-method}
\alias{QCfail}
\alias{QCfail,ChipInfo-method}
\alias{QCpass}
\alias{QCpass,ChipInfo-method}
\title{Access quality control pass or fail codes for ChipInfo}
\usage{
QCcode(x)

\S4method{QCcode}{ChipInfo}(x)

QCcode(x) <- value

\S4method{QCcode}{ChipInfo}(x) <- value

QCpass(x)

QCfail(x, type = NA)

\S4method{QCpass}{ChipInfo}(x)

\S4method{QCfail}{ChipInfo}(x, type = NA)
}
\arguments{
\item{x}{a ChipInfo object}

\item{value}{new pass/fail codes, e.g, 0,1,...,n}

\item{type}{integer between 1 and 100, failure type (user can assign own coding scheme)}
}
\value{
integer vector of pass/fail codes

QCcode<-: updates the object specified with new pass/fail codes for the 'QCcode' slot

QCpass: ChipInfo object for which SNPs pass quality control

QCfail: ChipInfo object for which SNPs fail quality control
}
\description{
Returns the pass or fail codes for each SNP of the chip object, 
e.g, 0,1,..,n etc
Only if these are added manually, or else all will be 'pass' (=0)

QCcode<-: Allows user to set the pass or fail codes for each SNP of the chip object, 
e.g, 0,1,..,n etc. 0 is always pass, >0 is always fail, but each integer
can be used to represent a different failure type, or for simplicity, stick
to 0 and 1, ie, just pass and fail.

QCpass: Returns the subset of the ChipInfo object for which SNPs pass quality
control, according to the QCcodes() slot == 0.

QCfail: Returns the subset of the ChipInfo object for which SNPs fail quality
control, according to the QCcodes() slot > 0.
}

