% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\docType{methods}
\name{rownames,ChipInfo-method}
\alias{dim,ChipInfo-method}
\alias{length,ChipInfo-method}
\alias{print,ChipInfo-method}
\alias{rownames,ChipInfo-method}
\alias{show,ChipInfo-method}
\title{rownames method for ChipInfo objects}
\usage{
\S4method{rownames}{ChipInfo}(x)

\S4method{dim}{ChipInfo}(x)

\S4method{length}{ChipInfo}(x)

\S4method{show}{ChipInfo}(object)

\S4method{print}{ChipInfo}(x, ...)
}
\arguments{
\item{x}{a ChipInfo object}

\item{object}{a ChipInfo object}

\item{...}{further arguments to showChipInfo()}
}
\value{
rownames: Character vector of row names (SNP IDs).

dim: same as length

length: integer, number of rows, same as inherited nrow()

show: Displays a preview of the object

print: Prints the object to terminal using 'showChipInfo()'.
}
\description{
rownames: Returns the row names.

dim: Returns the dimension

length: Returns the number of rows

show: Displays a preview of the object

print: See 'show' as the behaviour is very similar and ... are just arguments of 'show'.
The key difference with 'print' instead of 'show' is that by default the parameter
'up.to' is set to 50, so that any ChipInfo object (or subset) of less than or equal
to 50 rows will be displayed in its entirety, rather than just the top/bottom 5 rows.
}

