% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance_exposure.R
\name{distance_exposure}
\alias{distance_exposure}
\title{Write storm distance exposure files}
\usage{
distance_exposure(locations, start_year, end_year, dist_limit, out_dir,
  out_type = "csv")
}
\arguments{
\item{locations}{Either a vector of FIPS county codes, for county-level
output, or a dataframe with columns for community identifier (\code{commun})
and associated FIPS codes (\code{fips}), for multi-county community output.
See the examples for the proper format for this argument.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{dist_limit}{Maximum distance, in kilometers, of how close the storm
track must come to the county's population mean center to classify
the county as "exposed" to the storm.}

\item{out_dir}{Character string giving the pathname of the directory in which
to write output. This directory should already exist on your computer.}

\item{out_type}{Character string giving the type of output files you'd like.
Options are \code{"csv"} (default) and \code{"rds"}.}
}
\value{
Writes out a directory with rain exposure files for each county or
   community indicated. For more on the columns in this output, see the
   documentation for \code{\link{county_rain}} and
   \code{\link{multi_county_rain}}.
}
\description{
This function takes an input of locations (either a vector of county FIPS
or a dataframe of multi-county FIPS, with all FIPS listed for each county)
and creates a dataframe with storm listings and dates that can be merged with
time series of health or other outcomes, giving the dates and exposures for all
storms meeting the given storm distance criteria.
}
\examples{
\dontrun{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

# By county
distance_exposure(locations = c("22071", "51700"),
              start_year = 1995, end_year = 2005,
              dist_limit = 75,
              out_dir = "~/tmp/storms")

# For multi-county communities
communities <- data.frame(commun = c(rep("ny", 6), "no", "new"),
                          fips = c("36005", "36047", "36061",
                          "36085", "36081", "36119",
                          "22071", "51700"))
distance_exposure(locations = communities,
              start_year = 1995, end_year = 2005,
              dist_limit = 75,
              out_dir = "~/tmp/storms")
}
}
}

