% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rain_exposure.R
\name{rain_exposure}
\alias{rain_exposure}
\title{Write storm rain exposure files}
\usage{
rain_exposure(locations, start_year, end_year, rain_limit, dist_limit,
  days_included = c(-2, -1, 0, 1), out_dir, out_type = "csv")
}
\arguments{
\item{locations}{Either a vector of FIPS county codes, for county-level
output, or a dataframe with columns for community identifier (\code{commun})
and associated FIPS codes (\code{fips}), for multi-county community output.
See the examples for the proper format for this argument.}

\item{start_year}{Four-digit integer with first year to consider.}

\item{end_year}{Four-digit integer with last year to consider.}

\item{rain_limit}{Minimum of rainfall, in millimeters, summed across the days
selected to be included (\code{days_included}), that must fall in a
county for the county to be classified as "exposed" to the storm.}

\item{dist_limit}{Maximum distance, in kilometers, of how close the storm
track must come to the county's population mean center to classify
the county as "exposed" to the storm.}

\item{days_included}{A numeric vector listing the days to include when
calculating total precipitation. Negative numbers are days before the
closest date of the storm to a county. For example,
\code{c(-1, 0, 1)} would calculate rain for a county as the sum of the
rainfall for the day before, the day of, and the day after the date when
the storm center was closest to the county center. Values can range from
-5 to 3 (i.e., at most, you can calculate the total rainfall from five days
to three days after the day when the storm is closest to the
county).}

\item{out_dir}{Character string giving the pathname of the directory in which
to write output. This directory should already exist on your computer.}

\item{out_type}{Character string giving the type of output files you'd like.
Options are \code{"csv"} (default) and \code{"rds"}.}
}
\value{
This function writes out rain exposure files for each county or
   community indicated to the specified output directory (\code{out_dir}).
   For more details on the columns in the output files, see the
   documentation for \code{\link{county_rain}} and
   \code{\link{multi_county_rain}}.
}
\description{
This function takes an input of locations (either a vector of county FIPS
or a dataframe of multi-county FIPS, with all FIPS listed for each county;
see examples) and creates time series dataframes with the dates and exposures
for all storms meeting the given rainfall and storm distance criteria. These
exposure time series can then be merged with other time series (e.g.,
community-specific daily counts of health outcomes).
}
\examples{
\dontrun{
# Ensure that data package is available before running the example.
#  If it is not, see the `hurricaneexposure` package vignette for details
# on installing the required data package.
if (requireNamespace("hurricaneexposuredata", quietly = TRUE)) {

# For these examples, you need to have a directory in your home
# directory called "tmp".

# By county
rain_exposure(locations = c("22071", "51700"),
              start_year = 1995, end_year = 2005,
              rain_limit = 100, dist_limit = 100,
              out_dir = "~/tmp/storms")

# For multi-county communities
communities <- data.frame(community_name = c(rep("ny", 6), "no", "new"),
                          fips = c("36005", "36047", "36061",
                          "36085", "36081", "36119",
                          "22071", "51700"))
rain_exposure(locations = communities,
              start_year = 1995, end_year = 2005,
              rain_limit = 100, dist_limit = 100,
              out_dir = "~/tmp/storms")
}
}
}
