% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{print.huxtable}
\alias{print.huxtable}
\alias{format.huxtable}
\title{Format and print huxtables using a default method}
\usage{
\method{print}{huxtable}(x, ...)

\method{format}{huxtable}(x, ..., output = c("latex", "html", "md", "screen", "rtf", "typst"))
}
\arguments{
\item{x}{A huxtable.}

\item{...}{Options passed to other methods.}

\item{output}{Output format. One of \code{"html"}, \code{"latex"}, \code{"md"}, \code{"screen"}, \code{"rtf"} or \code{"typst"}.}
}
\value{
\code{print} prints the huxtable and returns \code{NULL} invisibly.

\code{format} returns a string representation from \code{\link[=to_latex]{to_latex()}}, \code{\link[=to_html]{to_html()}} etc.
}
\description{
By default huxtables are printed using \code{\link[=print_screen]{print_screen()}}. In certain cases, for example
in Sweave documents, it may be
useful to change this. You can do so by setting \code{options("huxtable.print")}.
}
\examples{
\dontrun{
# to print LaTeX output:
options(huxtable.print = print_latex)
# to print Typst output:
options(huxtable.print = print_typst)
}

format(jams, output = "screen")
format(jams, output = "md")
format(jams, output = "typst")
}
\seealso{
To change how huxtables are printed within \code{knitr}, see
\code{options("huxtable.knitr_output_format")} in \link{huxtable-options}
}
