% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassDefinitions.R
\docType{class}
\name{CSarbitrary-class}
\alias{CSarbitrary-class}
\alias{CSarbitrary}
\title{CSarbitrary Class}
\description{
Defines a cross-section class with arbitrary geometry for
  hydraulic calculations. For single open channels only, avoid geometries
  with multiple channels.
}
\section{Slots}{

\describe{
\item{\code{x}}{A numeric vector of x-coordinates [m].}

\item{\code{z}}{A numeric vector of z-coordinates [m].}

\item{\code{xb_l}}{x-coordinate of the left bank bottom [m].}

\item{\code{xb_r}}{x-coordinate of the right bank bottom [m].}

\item{\code{kSt_B}}{Roughness of the channel bed [m^(1/3)/s].}

\item{\code{kSt_l}}{Roughness of the left bank [m^(1/3)/s].}

\item{\code{kSt_r}}{Roughness of the right bank [m^(1/3)/s].}
}}

\examples{
# Define sample cross-section data
x <- c(0, 4, 9, 13)
z <- c(2, 0, 0, 2)
cs <- new("CSarbitrary", x = x, z = z, xb_l = 4, xb_r = 9,
          kSt_B = 35, kSt_l = 45, kSt_r = 45)
}
