% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{event_type}
\alias{event_type}
\title{Event Type}
\usage{
event_type(x)
}
\arguments{
\item{x}{Data frame (time series) from an event with equal flow trend. Data
frame must contain a date-time column (\code{Time}) and a flow rate column
(\code{Q}) and must be in a compatible format. (see \code{\link[=flow]{flow()}}).}
}
\value{
Returns an numeric value which indicates the event type.
Event types are defined as follows:
\itemize{
  \item 0: Constant event after NA event or constant event as first event in time series
  \item 1: Constant event after DC
  \item 2: Increasing event (IC)
  \item 3: Constant event after IC
  \item 4: Decreasing event (DC)
  \item 5: NA event
}
}
\description{
Given a data frame (time series) of equal flow (Q) trend, it is
    determined whether the flow is increasing or decreasing, constant or if
    missing values occur. It returns a numeric value which indicates the event
    type. As the event type is already determined when the change points are
    computed, this function is mainly used for demonstration purpose or if
    metrics should be computed individually.
}
\examples{
data(Q)
# decreasing event
Q4 <- flow(Q[3:4, ])
event_type(Q4)

# increasing event
Q2 <- flow(Q[486:487, ])
event_type(Q2)

}
