% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMeanPreci.R
\name{getMeanPreci}
\alias{getMeanPreci}
\title{Get mean rainfall data.}
\usage{
getMeanPreci(inputTS, method = NULL, yearIndex = NULL,
  monthIndex = NULL, fullResults = FALSE, omitNA = TRUE,
  plot = FALSE, ...)
}
\arguments{
\item{inputTS}{A time series with only data column (1 column).}

\item{method}{A string showing the method used to calculate mean value, e.g., "annual".
more information please refer to details.}

\item{yearIndex}{A NUMERIC ARRAY showing the year index of the time series.}

\item{monthIndex}{A NUMERIC ARRAY showing the month index of the time series.}

\item{fullResults}{A boolean showing whether the full results are shown, default is FALSE. If 
FALSE, only mean value will be returned, if TRUE, the sequence of values will be returned.}

\item{omitNA}{A boolean showing in the calculation, whether NA is omitted, default is FALSE.}

\item{plot}{A boolean showing whether the results will be plotted.}

\item{..., }{\code{title, x, y} showing the title and x and y axis of the plot, shoud be a string.}
}
\value{
The mean value of the input time series or the full results before calculating mean.
}
\description{
Get mean rainfall data, e.g. mean annual rainfall, mean monthly rainfall and mean winter rainfall.
}
\details{
There are following methods to be selected, 
"annual": annual rainfall of each year is plotted.  
"winter", "spring", "autumn", "summer": seasonal rainfall of each year is plotted.
Month(number 1 to 12): month rainfall of each year is plotted, e.g. march rainfall of each year.
"meanMonthly": the mean monthly rainfall of each month over the whole period.

Since "winter" is a crossing year, 12, 1, 2, 12 is in former year, and 1, 2 are in latter year.
so winter belongs to the latter year.
}
