% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slideWindows.R
\name{slideWindows}
\alias{slideWindows}
\title{Create Sliding Windows Over a Spatial Object}
\usage{
slideWindows(x, n = c(8, 8))
}
\arguments{
\item{x}{A spatial object where an extent can be extracted from.
Classes: \code{Extent}, \code{RasterLayer}, \code{RasterBrick},
\code{RasterStack} (from package \link{raster}).}

\item{n}{An integer vector of length two determining the number of divisions
in x and y directions. Default is \code{n = c(8, 8)}, which creates 64
windows.}
}
\value{
An object of class \code{slideWindows}, which consists of a list
of each sliding-windows extent.
}
\description{
Create a prefixed number of non-overlapping sliding windows that cover
the entire extent of a spatial object.
}
\examples{
# Example 1
p <- system.file('exdata', 'soybean.tif', package = 'hyperbrick')
im <- brick(p)
plotRGB(im)

sw <- slideWindows(im, n = c(8, 8))
lapply(sw, lines) -> null_obj
lines(sw[[1]], col = "white", lwd = 3)
lines(sw[[64]], col = "white", lwd = 3)

# Example 2
ext <- extent(c(30, 350, 150, 230))
lines(ext, col = "red", lwd = 3)
sw2 <- slideWindows(ext, n = c(18, 6))
lapply(sw2, lines, col = "red") -> null_obj

}
\seealso{
\code{\link[=slideBrick]{slideBrick()}}, \link[raster:extent]{raster::extent}
}
