% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viewSpectra.R
\name{viewSpectra}
\alias{viewSpectra}
\title{Spectral Signature of a Hyperspectral Image}
\usage{
viewSpectra(x, ...)
}
\arguments{
\item{x}{A numeric matrix or vector containing the values to be plotted at
each spectral band (wavelength). Generally, an object obtained with
\code{\link[=slideBrick]{slideBrick()}}.}

\item{...}{Further graphical parameters. See \code{\link[=par]{par()}}.}
}
\description{
Visualize statistics calculated through the bands of a hyperspectral image.
}
\examples{
p <- system.file('exdata', 'obory.dat', package = 'hyperbrick')
im <- buildBrick(p, ref_layer = 35,
                spectral_feature = "radiance",
                hFOV = 36.8, vFOV = 36.8, height = 45)
plotRGB(im, r = 63, b = 34, g = 11, scale = 90, axes = TRUE)

sw <- slideWindows(im)
lapply(sw, lines, col = "white") -> null_obj

sb <- slideBrick(im, sw, fun = mean)
head(sb)

viewSpectra(sb, ylab = "Radiance")

}
\seealso{
\code{\link[=slideBrick]{slideBrick()}}
}
