% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IARsmoothing.R
\name{IARsmoothing}
\alias{IARsmoothing}
\title{Interpolation predictor of the iAR Model}
\usage{
IARsmoothing(
  x,
  st,
  y,
  grid,
  delta = 0,
  zero.mean = "FALSE",
  standarized = "TRUE"
)
}
\arguments{
\item{x}{A given phi coefficient of the IAR model.}

\item{st}{Array with the irregular observational times.}

\item{y}{Array with the time series observations.}

\item{grid}{Array with the times in which the interpolation predictor will be computed.}

\item{delta}{Array with the measurements error standard deviations.}

\item{zero.mean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}

\item{standarized}{logical; if true, the array y is standarized; if false, y contains the raw time series.}
}
\value{
A list with the following components:
\itemize{
\item{yhat}{One step interpolation predictor of the iAR model for each given time.}
\item{grid}{Times in which the interpolation predictor was computed.}
}
}
\description{
One step interpolation predictor of the iAR Model
}
\examples{
n=300
set.seed(6713)
st<-gentime(n)
y<-IARsample(phi=0.9,st=st,n=n)
y<-y$series
phi=IARkalman(y=y,st=st)$phi
napos=10
y0=y
yest=IARsmoothing(x=phi,st=st[-napos],y=y[-napos],grid=st[napos])
print(yest)
}
\references{
\insertRef{Elorrieta_2021}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARsample}}, \code{\link{IARloglik}}
}
